﻿<%@LANGUAGE="VBSCRIPT"%>
<!--#include file="../../lib/methods.asp"-->
<%
Const ForReading = 1, ForWriting = 2, ForAppending = 8
Const TristateUseDefault = -2, TristateTrue = -1, TristateFalse = 0
Dim fso, f, ts, filename

set util = server.CreateObject("procview.util")
set osInfo = Server.CreateObject("procview.ServerInfo").osInfo(cstr(session("computer"))) 
set sysInfo = Server.CreateObject("procview.ServerInfo").getInfo(cstr(session("computer")))
set nicInfo =  Server.CreateObject("procview.ServerInfo").getNicInfo(cstr(session("computer")))
set patchList = Server.CreateObject("ProcView.ServerInfo").OsHotFixStatus(cstr(session("computer")))
'set diskInfo =  Server.CreateObject("procview.ServerInfo").logicalDriveInfo(cstr(session("computer"))) 
set cpuInfo =  Server.CreateObject("procview.ServerInfo").cpuInfo(cstr(session("computer"))) 

path 	= server.mappath("../../datafiles")
filename = path & "\" &  lcase(session("workgroup")) & "_" & lcase(session("computer")) & ".txt"

Set fso = CreateObject("Scripting.FileSystemObject")
	fso.CreateTextFile filename
Set f = fso.GetFile(filename)
Set ts = f.OpenAsTextStream(ForWriting, TristateUseDefault)
	ts.writeLine string(76,"=")
	ts.writeLine "Backbone Software NT Services " & application("appMajor") & "." & application("appMinor")
	ts.writeLine "http://www.backbonesoftware.no" & " - " & now() 
	ts.writeLine string(76,"=")
	ts.writeLine
	head = "SERVER INFO: "
	ts.writeLine head & string((76-len(head)),"*")
	ts.WriteLine "Operating system: " & vbTab & vbTab & replace(osInfo("OperatingSystem"), "Microsoft ", "") & ", " & osInfo("ServicePack") & " (" &osInfo("SPMajor") & "." &  osInfo("SPMinor") & ")"
	ts.writeLine "Serial number: " & vbTab & vbTab & vbTab & osInfo("SerialNumber")
	ts.writeLine "Windows build: " & vbTab & vbTab & vbTab & osInfo("WindowsVersion")
	ts.writeLine "Role:"  & vbTab & vbTab &  vbTab & vbTab &  vbTab &  sysInfo("DomainRole")
	ts.writeLine "Workgroup/Domain:" & vbTab & vbTab & session("workgroup")
	ts.writeLine "Server:" & vbTab & vbTab &  vbTab & vbTab &  vbTab & session("computer")
	ts.writeLine "Installed memory: "  & vbTab & vbTab &  sysInfo("PhysicalMemory")
	ts.writeLine "System type: " & vbTab & vbTab &  vbTab & sysInfo("SystemType")
	ts.writeLine "Manufacturer: "& vbTab & vbTab &  vbTab &  sysInfo("ComputerManufacturer")

	ts.writeLine
	head = "MOTHERBOARD: "
	ts.writeLine head & string((76-len(head)),"*")	
	ts.writeLine "Manufacturer: "& vbTab & vbTab & vbTab &  sysInfo("MotherBoardManufacturer")
	ts.writeLine "Product: " & vbTab &vbTab & vbTab &  vbTab & sysInfo("MotherBoardProduct")
	ts.writeLine "Version: " & vbTab& vbTab & vbTab &  vbTab &  sysInfo("MotherBoardVersion")
	ts.writeLine "BIOS " & vbTab & vbTab &  vbTab & vbTab &  vbTab &  sysInfo("BIOSDescription")
	ts.writeLIne "BIOS version: " & vbTab & vbTab &  vbTab &  sysInfo("BIOSVersion")
	ts.writeLIne "BIOS manufacturer: " &  vbTab &  vbTab &   sysInfo("BIOSManufacturer")
	ts.writeLine "BIOS Serialnumber: " & vbTab & vbTab &  vbTab &  sysInfo("BIOSSerialNumber")
	if isdate(sysInfo("BIOSReleaseDate")) then  
		reldate = util.formatDateTime(sysInfo("BIOSReleaseDate"),vbLongDate) 
	else 
		reldate = sysInfo("BIOSReleaseDate") 
	end if
	ts.writeline "BIOS Releasedate: " & vbTab & vbTab & reldate
	ts.writeLine
	head = "SYSTEM CPU: "
	ts.writeLine head & string((76-len(head)),"*")	
	for each cpu in cpuInfo
		ts.writeline "ID: " & cpu("DeviceID")
		ts.writeline vbTab & "Type: " & cpu("CPUName")
		speed = clng(cpu("ClockSpeed"))
		if speed > 1000 then
			speed = formatNumber((speed/1000),2) & "Ghz"
		else
			speed = speed & "Mhz"
		end if
		ts.writeline vbTab & "Clockspeed: " & speed
		ts.writeline vbTab & "CPU socket: " & cpu("Socket")
		if not isnull(cpu("L2CacheSize"))  then 
			if clng(cpu("L2CacheSize")) > 0 then
				ts.WriteLIne vbTab & "L2Cache: " & cpu("L2CacheSize") & " Kb"
			end if
		end if
	next
	ts.writeLine
	head = "NETWORK ADAPTERS: "
	ts.writeLine head & string((76-len(head)),"*")	
	for each nic in nicInfo
		ts.writeline nic("NICName")
		ts.writeline vbTab & "Mac address: " & nic("MACAddress")
		ts.writeline vbTab & "DNS Hostname: " & nic("DNSHostName")
		ts.writeline vbTab & "DNS Domain: " & nic("DNSDomain")
		ts.writeline vbTab & "Mac address: " & nic("MACAddress")
		set ip = nic("StaticIP")
		ts.write vbTab  & "IP Address: "
			for each i in ip
				ts.write i
				if ip.count > 1 then
				ts.write ", "
				end if
			next
			ts.write vbCrlf

		ts.write vbTab & "Subnet: " 
		set ip = nic("SubNet")
			for each i in ip
				ts.write i
				if ip.count > 1 then
				ts.write ", "
				end if
			next
			ts.write vbCrlf
		
		ts.write vbTab & "Gateway: " 
		set ip = nic("GateWay")
			for each i in ip
				ts.write i
				if ip.count > 1 then
				ts.write ", "
				end if
			next
			ts.write vbCrlf
	next
	ts.writeLine
	head = "OS HOTFIX: "
	ts.writeLine head & string((76-len(head)),"*")
	for each patch in patchList
		if not trim(patch("HotFixID")) = "Q147222" then
			if not trim(patch("HotFixID")) = "File 1" then
				ts.WriteLine "Patch: " & patch("HotFixID")
				ts.WriteLine "Install by: " & patch("InstalledBy")
				ts.WriteLine patch("Description")
				ts.writeLine
			end if
		end if
	next
	ts.writeLine
	head = "SERVICES: "
	ts.writeLine head & string((76-len(head)),"*")
	set serviceInfo = Server.CreateObject("ProcView.Services")
		serviceInfo.setWorkgroup = cstr(session("workgroup"))
		serviceInfo.setComputerName = cstr(session("computer"))
		set serviceList = serviceInfo.servicesSorted("DisplayName")
	set meth = new Methods
	
	for each service in serviceList
		ts.writeLine service("DisplayName")
		ts.writeLine vbTab & "Service: " & service("Name")
		ts.writeLine vbTab & "Status: " &  meth.serviceStatus(service("Status"))
		ts.writeLine vbTab & "Startup: " & meth.startType(service("StartType"))
		ts.writeLine
	next
	ts.Close
set util 		= nothing
set osInfo 		= nothing
set sysInfo 	= nothing
set nicInfo 	=  nothing
set patchList 	= nothing
'set diskInfo 	=  nothing
set cpuInfo 	=  nothing
set meth 		= nothing
set fso = nothing
set f = nothing
set ts = nothing
Response.Buffer = True
Const adTypeBinary = 1

Set fstream = Server.CreateObject("ADODB.Stream")
fstream.Open
fstream.Type = adTypeBinary
fstream.LoadFromFile filename

Response.Clear
Response.AddHeader "Content-Disposition", "attachment; filename=""" & lcase(session("workgroup")) & "_" & lcase(session("computer")) & ".txt" & """"
'Response.AddHeader "Content-Length", file.Size
Response.Charset = "UTF-8"
if session("pocketPC") = true then
	Response.ContentType = "application/octet-stream"
else
	Response.ContentType = "text/plain"
end if
Response.BinaryWrite fstream.Read
Response.Flush
fstream.Close


%>